<?php

/////////////////////////////////////////////////////////////////////////////////////////

function get_alexa_data($domain, &$rank, &$links, &$reach) 
{ 
	$url = "http://data.alexa.com/data?cli=10&dat=s&url=" . 'http://' . $domain; 
	$xml = file_get_contents($url); 
	
	$rank  = (preg_match('/POPULARITY URL="[a-z0-9\\-\\.\\/]{1,}" TEXT="([0-9]{1,12})"/',$xml,$regs) ? number_format($regs[1]) : 0); 
    $reach = (preg_match('/REACH RANK="([0-9]{1,12})"/',$xml,$regs) ? number_format($regs[1]) : 0); 
    $links = (preg_match('/LINKSIN NUM="([0-9]{1,12})"/',$xml,$regs) ? number_format($regs[1]) : 0); 
	
	$rank  = str_replace(",", "", $rank);
	$rank  = str_replace(".", "", $rank);
	$links = str_replace(",", "", $links);
	$links = str_replace(".", "", $links);
	$reach = str_replace(",", "", $reach);
	$reach = str_replace(".", "", $reach);
} 
 
/////////////////////////////////////////////////////////////////////////////////////////

function get_alexa_records($domain, $subdomain="www")
{
	$host = idn_convert_to_host_name($domain, $subdomain);
	
	get_alexa_data($domain, $rank, $links, $reach);
	
	$data_array['alexa_rank'] = $rank;
	$data_array['alexa_links'] = $links;
	$data_array['alexa_checked_at'] = date("Y-m-d H:i:s");
	
	if(is_array($data_array))
		update_domain_table($data_array, $domain);
}


/////////////////////////////////////////////////////////////////////////////////////////

?>
