///////////////////////////////////////////////////////////////////////////////

var current_whois_server = "";

///////////////////////////////////////////////////////////////////////////////

$(function()
{
	jQuery("#DomainTLDTable").jqGrid({
		url: grid_url_base + '?mode=tld',
		editurl: grid_url_base + '?mode=tld',
		datatype: "json",
		altRows:true,
		altclass: 'gridAltRowClass',
		scrollOffset: 18,
		rownumbers: true,
	   	colNames:['TLD', 'Whois Server'],
	   	colModel:[
			{name:'tld',width:25, align:"left",sortable:true, hidden:false, editable:true},
			{name:'server',width:50, align:"left",sortable:true, hidden:false, editable:true},
	   	],
	   	multiselect: false,
		//loadonce: true,
		sortname: 'tld',
		headertitles: true,
	   	caption: "TLDs",
		pager: "#pagerDomainTLDView",
		rowNum: 200,
		loadComplete: function()
		{
			jQuery("#ControlPane").trigger('resize');
			fixDomainDataGridSizes();
		},
		
		onSelectRow: function(ids) 	
		{
			showTLDData(ids);
		},
		
		onSelectAll: function() 	{}
	}).navGrid('#pagerDomainTLDView',{add:true,edit:true,del:true,search:false});
	
	$("#ControlPane").bind('resize', function() { fixDomainDataGridSizes();	}).trigger('resize');
	
	jQuery("#DomainTLDTable").jqGrid(
		'filterToolbar',{
			stringResult: true,searchOnEnter : false
		}
	);
	
	$("#ui_whois_server_data_submit").button().click(function() 
	{
		var server = $('#whois_server_ui').val();
		if (server.toLowerCase() == current_whois_server.toLowerCase() && server != "")
		{
			var stopped = $('#whois_server_stopped_ui').is(":checked");
			var datastr = 'server=' + $("#whois_server_ui").val() + "&query=" + $("#query_string_ui").val() + "&port=" + $("#port_ui").val();
			datastr += "&dateformat=" + $("#date_format_ui").val() + "&searchtoken=" + $("#search_token_ui").val();
			datastr += "&conninterval=" + $("#connection_interval_ui").val();
			datastr += "&proxy=" + encodeURIComponent($("#http_proxy_ui").val());
			datastr += "&bannedtext=" + $("#ip_blocked_text_ui").val();
			datastr += "&stop_lookups=" + stopped;
			datastr += "&xlate=" + $("#xlate_array_ui").val();
			var turl = "lib/php/whoisconfig.php?set=1";
			var request = $.ajax({type: "POST",	url: turl, data: datastr});
			request.done(function(msg) 
			{  
				var x = jQuery.parseJSON(msg);
				$('#xlate_array_ui').val(x.xlate);
				$('#port_ui').val(x.port);
				$('#search_token_ui').val(x.searchtoken);
				$('#query_string_ui').val(x.query);
				$('#date_format_ui').val(x.dateformat);
				$('#max_connesctions_ui').val(x.maxconnections);
				$('#connection_interval_ui').val(x.conninterval);
				$('#http_proxy_ui').val(x.proxy);
				$('#ip_blocked_text_ui').val(x.bannedtext);
				if(x.stop_lookups == "1")
					$('#whois_server_stopped_ui').attr('checked','checked');
				else
					$('#whois_server_stopped_ui').removeAttr('checked');
				$('#ui_whois_server_last_connect').html(x.last_connect_at);
			});
			request.fail(function(jqXHR, textStatus) {});
		}
		else
		{
			$('#whois_server_mismatch').html("Please retrieve the data for this whois server by clicking the 'set' button at the top.");
		}
	});
	
	$("#whois_server_ui_submit").button().click(function() 
	{
		var server = $('#whois_server_ui').val();
		jQuery("#formhead").html("<h3>" + server + "</h3>");
		var turl = "lib/php/whoisconfig.php" + "?server=" + server;
		var request = $.ajax({type: "POST",	url: turl});
		request.done(function(msg) 
		{  
			var x = jQuery.parseJSON(msg);
			$('#xlate_array_ui').val(x.xlate);
			$('#port_ui').val(x.port);
			$('#search_token_ui').val(x.searchtoken);
			$('#query_string_ui').val(x.query);
			$('#date_format_ui').val(x.dateformat);
			$('#max_connesctions_ui').val(x.maxconnections);
			$('#connection_interval_ui').val(x.conninterval);
			$('#http_proxy_ui').val(x.proxy);
			$('#ip_blocked_text_ui').val(x.bannedtext);
			if(x.stop_lookups == "1")
				$('#whois_server_stopped_ui').attr('checked','checked');
			else
				$('#whois_server_stopped_ui').removeAttr('checked');
			current_whois_server = server;
			$('#whois_server_mismatch').html('');
			$('#ui_whois_server_last_connect').html(x.last_connect_at);
		});
		request.fail(function(jqXHR, textStatus) {});
	});
	
	$("#whois_server_conect_time_reset").button().click(function() 
	{
		var server = $('#whois_server_ui').val();
		var turl = "lib/php/whoisconfig.php" + "?resetserver=" + server;
		var request = $.ajax({type: "POST",	url: turl});
		request.done(function(msg) 
		{  
			var x = jQuery.parseJSON(msg);
			$('#whois_server_mismatch').html('');
			$('#ui_whois_server_last_connect').html(x.last_connect_at);
		});
		request.fail(function(jqXHR, textStatus) {});
	});

	$('#WhoisSetupTabView').tabs();
});


function showTLDData(ids)
{
	if(ids == null || ids == 0)
		;
	else
	{
		var server = jQuery("#DomainTLDTable").getCell(ids, "server"); 
		current_whois_server = server;
		jQuery("#formhead").html("<h3>" + server + "</h3>");
		var turl = "lib/php/whoisconfig.php" + "?tld=" + ids;
		var request = $.ajax({type: "POST",	url: turl});
		request.done(function(msg) 
		{  
			var x = jQuery.parseJSON(msg);
			$('#whois_server_ui').val(x.server);
			$('#xlate_array_ui').val(x.xlate);
			$('#port_ui').val(x.port);
			$('#search_token_ui').val(x.searchtoken);
			$('#query_string_ui').val(x.query);
			$('#date_format_ui').val(x.dateformat);
			$('#max_connesctions_ui').val(x.maxconnections);
			$('#connection_interval_ui').val(x.conninterval);
			$('#http_proxy_ui').val(x.proxy);
			$('#ip_blocked_text_ui').val(x.bannedtext);
			if(x.stop_lookups == "1")
				$('#whois_server_stopped_ui').attr('checked','checked');
			else
				$('#whois_server_stopped_ui').removeAttr('checked');
			$('#whois_server_mismatch').html('');
			$('#ui_whois_server_last_connect').html(x.last_connect_at);
		});
		request.fail(function(jqXHR, textStatus) {});
	}
}

function fixDomainDataGridSizes()
{
	var autoShrink = true;
	var bgap = 30+24;
	if($("#ControlPane").width() < 100)
		autoShrink = false;
	jQuery("#DomainTLDTable").setGridWidth($("#ControlPane").width()-20, autoShrink); 
	jQuery("#DomainTLDTable").setGridHeight($("#ControlPane").height()-66-bgap); 
	
	var dheight = $(window).height();
	jQuery("#WhoisSetupTabView").height(dheight-82, true); 
}
