<?php
///////////////////////////////////////////////////////////////////////////////////////////////////
#  Author:   Anil Kumar
#  Version:	 1.0
#  Date:     07-Oct-2013
#  Purpose:  
#  Requires: PHP 5.2+, MySQL 4.1.3+
#  Last Modified: Nov 07, 2013, SK
#  Modified by: SK
#
#  Copyright 2013, Softnik Technologies.
///////////////////////////////////////////////////////////////////////////////////////////////////
	
require_once("lib/php/config.check.php");
require_once("config.php");
require_once("lib/php/base.php");

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# Only admin users can use this script.
# If user authentication is disabled, everyone is an admin user!

session_start();
check_authentication_login();
if(is_admin_user() == false)
{
	header("Location: " . get_base_path());
	exit;
}
doSessionSwipeIn();

/////////////////////////////////////////////////////////////////////////////////////////////////////////

if(isset($_REQUEST['emset']))
{
	$output = array();
	$output['status'] = "none";
	$output['count'] = 0;
	$output['keys'] = "";
	global $app_config;
	
	global $multi_server_global_settings;
	global $db_config_host, $db_config_database, $db_config_username, $db_config_password, $db_table_prefix;
	require_once("lib/php/pdo/cppdo.php");
	require_once("lib/php/preferences.php");
	$pdo = new cpPreferences($db_table_prefix);
	$dbh = $pdo->openMySQL($db_config_host, $db_config_database, $db_config_username, $db_config_password);
	if($dbh)
	{
		foreach($_REQUEST as $key=>$uvalue) 
		{
			$key = trim($key);
			//$output['keys'] .= $key . "[$uvalue]\n";
			if(in_array($key, array_keys($app_config)))
			{
				if($key == 'id')
					continue;
					
				$real_field_name = $key;
				if($multi_server_global_settings == false)
					$key = _get_install_server_id_() . "-" . $key;
				else
					$key = "master_" . $key;
	
				if($real_field_name == 'email_smtp_port' || $real_field_name == 'email_word_wrap')
				{
					$uvalue = intval($uvalue);
					$pdo->setNumber($key, $uvalue);
				}
				else if($real_field_name == "email_smtp_password")
				{
					$uvalue = rc4two($uvalue . substr(md5(uniqid(rand(), true)), 0, 25), md5("160119661604199705011969"));
					$pdo->setValue($key, $uvalue);
				}
				else
				{
					$pdo->setValue($key, $uvalue);
				}
				$output['count']++;
			}
		}
		$output['status'] = "done";
	}
	echo json_encode($output);
	exit;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

if(isset($_REQUEST['opset']))
{
	$output = array();
	$output['status'] = "none";
	$is_text_field = false;
	$is_num_field = false;
	$field = simple_sanitize($_REQUEST['opset']);
	$valid_text_fields = array('default_lookup_types', 'high_preference_lookups', 'license_key_code', 'ui_theme',
								'home_page_link', 'product_page_link', 'support_page_link', 'contact_page_link', 
								'main_logo_image', 'legal_licensee_name', 'config_subdomain_entry', 'cell_date_format',
								'custom_tools_file', 'admin_user_name', 'admin_password', 'default_sub_domains', 'cli_auth_key_code' );
	$valid_num_fields = array('do_dns_record_lookup', 'requeue_on_empty_whois', 'home_page_max_redirs', 'multi_server_global_settings',
							  'fix_host_domain_names', 'auth_timeout_minutes', 'max_login_attempts', 'login_lockout_minutes',
								'domain_grid_search'							  
							);
	if(in_array($field, $valid_text_fields))
		$is_text_field = true;
	else if(in_array($field, $valid_num_fields))
		$is_num_field = true;
	if($is_num_field || $is_text_field)
	{
		if(isset($_REQUEST['value']))
		{
			$value = $_REQUEST['value'];
			global $db_config_host, $db_config_database, $db_config_username, $db_config_password, $db_table_prefix;
			require_once("lib/php/pdo/cppdo.php");
			require_once("lib/php/preferences.php");
			$pdo = new cpPreferences($db_table_prefix);
			$dbh = $pdo->openMySQL($db_config_host, $db_config_database, $db_config_username, $db_config_password);
			if($dbh)
			{
				global $multi_server_global_settings;
				if($multi_server_global_settings == false && $field != "multi_server_global_settings")
					$field_name = _get_install_server_id_() . "-" . $field;
				else
					$field_name = "master_" . $field;
			
				if($field == "admin_password" && $value != "")
				{
					$value = generateHash($value);
				}
				else if($field == "cli_auth_key_code" && $value != "")
					$value = rc4two($value . substr(md5(uniqid(rand(), true)), 0, 25), md5("160119661604199705011969"));
				
				$pdo->initTables();
				if($is_text_field)
					$pdo->setValue($field_name, $value);
				else if($is_num_field)
					$pdo->setNumber($field_name, $value);
				$output['status'] = "done";
				$output['value'] = $value;
				$output['key'] = $field_name;
			}
		}
	}
	echo json_encode($output);
	exit;
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////

if(isset($_REQUEST['gfield']))
{
	$output = array();
	
	$field = simple_sanitize($_REQUEST['gfield']);
	
	$output['save'] = "none";
	if(isset($_REQUEST['sfield']))
	{
		$ofield = simple_sanitize($_REQUEST['sfield']);
		if($ofield != "")
		{
			$width = simple_sanitize($_REQUEST['swidth']);
			$label = strip_tags(trim(($_REQUEST['slabel'])));
			if(log_column_label_and_width($ofield, $label, $width))
				$output['save'] = "done";
			else
				$output['save'] = "error";
		}
	}

	$width = 100;
	$label = getLabelFromFieldName($field);
				
	if($field != "")
	{
		$status = get_column_label_and_width($field, $label, $width);
		
		if($label == "")
			$label = getLabelFromFieldName($field);

		$output['field'] = $field;
		$output['width'] = $width;
		$output['label'] = $label;
		$output['status'] = "done";
	}
	else
		$output['status'] = "noget";
		
	echo json_encode($output);
	exit;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function get_base_dir()
{
	return realpath(dirname(__FILE__)) . DIRECTORY_SEPARATOR;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////
	
$jqtheme = get_theme_name("");
$title = "";
if($title == "")
	$title = "Domain Portfolio Manager - Application Settings";
$panesjs = "cfgpanes.js";

connect_to_mysql_and_select_db();

/////////////////////////////////////////////////////////////////////////////////////////////////////////

$allcolumns = "";

/////////////////////////////////////////////////////////////////////////////////////////////////////////

if(isset($_REQUEST['dgroup']))
{
	$dgroup = validate_request_data($_REQUEST['dgroup']);
	$entry = getTableColumnsForGroup($dgroup);
	$output['columns'] = $entry;
	echo json_encode($output);
	exit;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

if(isset($_REQUEST['dghtml']))
{
	$dgroup = validate_request_data($_REQUEST['dghtml']);
	$entry = getSelectableColumnsText($dgroup);
	$output['chtml'] = $entry;
	echo json_encode($output);
	exit;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

if(isset($_REQUEST['dgset']))
{
	$output['status'] = "none";
	$dgroup = validate_request_data($_REQUEST['dgset']);
	if(isset($_REQUEST['entry']))
	{
		$entry = validate_request_data($_REQUEST['entry']);
		if(set_tablecolumns_for_displaygroup($dgroup, $entry))
			$output['status'] = "done";
	}
	echo json_encode($output);
	exit;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

if(isset($_REQUEST['fieldset']))
{
	$outdata = array();
	global $db_allowed_domain_columns, $db_config_customfields_table;
	
	$field_name = get_request_variable("field_name", "");
	
	$field_name = trim($field_name, "\r\n\t; '`\"");
	$field_name = str_replace("'", "", $field_name);
	$field_name = str_replace("`", "", $field_name);
	$field_name = str_replace("?", "", $field_name);
	$field_name = str_replace("%", "", $field_name);
	$field_name = str_replace("#", "", $field_name);
	$field_name = str_replace("@", "", $field_name);
	$field_name = str_replace("&", "", $field_name);
	$field_name = str_replace("!", "", $field_name);
	$field_name = str_replace("~", "", $field_name);
	$field_name = str_replace("(", "", $field_name);
	$field_name = str_replace(")", "", $field_name);
	$field_name = str_replace("[", "", $field_name);
	$field_name = str_replace("]", "", $field_name);
	$field_name = str_replace("^", "", $field_name);
	$field_name = str_replace("*", "", $field_name);
	$field_name = str_replace("\"", "", $field_name);
	$field_name = str_replace("\\", "", $field_name);
	$field_name = str_replace("%26", "", $field_name);
	$field_name = str_replace("%20", " ", $field_name);
	$field_name = trim($field_name);
	
	$original_entry = $field_name;
	
	$field_name = strtolower(trim($field_name));
	$field_name = str_replace(" ", "_", $field_name);
	$field_name = str_replace(";", "_", $field_name);
	$field_name = str_replace(",", "_", $field_name);
	
	$field_act  = get_request_variable("fieldset", "insert");
	$field_type = get_request_variable("field_type", "varchar");
	$field_size = get_request_variable("field_size", "128");
	if($field_name != "")
	{
		if(!in_array($field_name, $db_allowed_domain_columns))
		{
			if(intval($field_size) < 10 || intval($field_size) > 255)
				$field_size = "128";
			if($field_type == "varchar")
				$field_type = "varchar(" . $field_size . ")";
			if($field_type == "bigint")
				$field_type = "bigint(20)";
			
			$sql = "";
			if($field_act == "insert")
				$sql  = "insert into $db_config_customfields_table (name,ftype) values ('$field_name', '$field_type');";
			else
			{
				$sqlCount = "SELECT COUNT(*) AS count FROM $db_config_customfields_table WHERE name='$field_name'";  
				$results = mysql_query($sqlCount) or die("Couldn't execute query.".mysql_error());
				$existing = mysql_fetch_array($results);  
				if ($existing['count'] > 0) 
					$sql  = "delete from $db_config_customfields_table WHERE name = '$field_name'";
			}
			if($sql != "")
			{
				$result = mysql_query($sql);
				if($result)
				{
					SetupAllowableFields();
					$allnames = getAllDomainColumns();
					$outdata['allnames'] = $allnames;
					if(!isset($outdata['status']))
						$outdata['status'] = 'done';
				}
				else
				{
					$outdata['status'] = "error";
				}
			}
		}
	}
	
	$ftypes = array();
	$flengths = array();
	
	if(!isset($outdata['status']))
		$outdata['status'] = 'none';
	$outdata['custom'] = getCustomFieldArray($ftypes, $flengths);
	$outdata['domcolumns'] = $db_allowed_domain_columns;
	$outdata['ctypes'] = $ftypes;
	$outdata['cwidths'] = $flengths;
	echo json_encode($outdata);
	exit;
}
else
{
	SetupAllowableFields();
	$allcolumns = getAllDomainColumns();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function getTableColumnsForGroup($dgroup)
{
	global $db_config_tablecolumns_table;
	
	$jsDefault = getDefaultColumnsForGroup($dgroup);
	
	$entry = "";
	$result = mysql_query('SELECT * FROM ' . $db_config_tablecolumns_table . " WHERE name = '" . $dgroup . "'");
	if($result)
	{
		while($row = mysql_fetch_array($result,MYSQL_ASSOC)) 
			$entry = trim($row['entry']);
	}
	
	if($entry == "")
		$entry = $jsDefault;
			
	return $entry;
}
	
/////////////////////////////////////////////////////////////////////////////////////////////////////////

function getAllDomainColumns()
{
	global $db_allowed_domain_columns;
	
	$ftypes = array();
	$flengths = array();
	$customfields = getCustomFieldArray($ftypes, $flengths);
	
	$allcolumns = "<ul id=\"domaincolumns\" class=\"bullets\">";
	$count = count($db_allowed_domain_columns);
	for($i = ($count-1); $i >= 0; $i--)
	{
		if(in_array($db_allowed_domain_columns[$i], $customfields))
			$allcolumns .= "<li class=\"highlight\">" . $db_allowed_domain_columns[$i] . "</li>";
		else
			$allcolumns .= "<li>" . $db_allowed_domain_columns[$i] . "</li>";
	}
	$allcolumns .= "</ul>";
	return $allcolumns;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function getSelectableColumnsText($displaygroup)
{
	global $db_allowed_domain_columns;
	
	SetupAllowableFields();
	
	$tablecolumns = getTableColumnsForGroup($displaygroup);
	$tbfields = explode(";", $tablecolumns);
		
	$cblist = "";
	foreach($tbfields as $tbcolumn)
	{
		if(in_array($tbcolumn, $db_allowed_domain_columns))
		{
			$cblist .= "\t\t\t\t\t\t\t\t<li><input id=\"cb-" . $tbcolumn . "\" type=\"checkbox\" checked>" . $tbcolumn . "</li>\n";
		}
	}
	
	$ftypes = array();
	$flengths = array();
	$csfields = getCustomFieldArray($ftypes, $flengths);
	foreach($csfields as $cscolumn)
	{
		if(in_array($cscolumn, $tbfields))
			continue;
		$cblist .= "\t\t\t\t\t\t\t\t<li><input id=\"cb-" . $cscolumn . "\" type=\"checkbox\">" . $cscolumn . "</li>\n";
	}
	
	$ccount = count($db_allowed_domain_columns);
	for($i = 0; $i < $ccount; $i++)
	{
		$column = $db_allowed_domain_columns[$i];
		if($column == "domain" || $column == "sid" || $column == "r_h_disp")
			continue;
		if(in_array($column, $tbfields))
			continue;
		if(in_array($column, $csfields))
			continue;
		$cblist .= "\t\t\t\t\t\t\t\t<li><input id=\"cb-" . $column . "\" type=\"checkbox\">" . $column . "</li>\n";
	}
	return $cblist;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function getCustomFieldArray(&$customFieldTypeArray, &$customFieldWidthArray)
{
	global $db_config_customfields_table;
	
	$custom_fields = array();
	
	$cfieldsres = mysql_query('SELECT * FROM ' . $db_config_customfields_table);
	if($cfieldsres)
	{
		while($crow = mysql_fetch_array($cfieldsres,MYSQL_ASSOC)) 
		{
			$fieldname = strtolower(trim($crow['name']));
			$fieldname = str_replace(" ","_", $fieldname);
			$custom_fields[] = $fieldname;
			
			$ftype = trim($crow['ftype']);
			$length = "";
			if(stristr($ftype, "varchar") !== false)
			{
				$customFieldTypeArray[] = "varchar";
				$length = substr($ftype, 8, strlen($ftype)-9);
			}
			else if(stristr($ftype, "bigint") !== false)
			{
				$customFieldTypeArray[] = "bigint";
				$length = substr($ftype, 7, strlen($ftype)-8);
			}
			else if(stristr($ftype, "text") !== false)
			{
				$customFieldTypeArray[] = "text";
			}
			else if(stristr($ftype, "datetime") !== false)
			{
				$customFieldTypeArray[] = "datetime";
			}
			else if(stristr($ftype, "date") !== false)
			{
				$customFieldTypeArray[] = "date";
			}
			else
				$customFieldTypeArray[] = "varchar";
			$customFieldWidthArray[] = intval($length);
		}
	}
	return $custom_fields;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function echoJSCustomFieldListArray()
{
	global $db_allowed_domain_columns;
	
	$ftypes = array();
	$flengths = array();	
	$fields = getCustomFieldArray($ftypes, $flengths);
	
	$output = "";
	echo "\t\t<script type=\"text/javascript\">\n";
	echo  "\t\t\tvar custom_field_array = [\n\t\t\t";
	foreach($fields as $field)
	{
		$output .= "'" . $field . "'";
		$output .= ", ";
	}
	$output = trim($output, "\n\r\t, ");
	echo $output;
	echo "\n\t\t\t];\n";
	
	$output = "";
	echo  "\t\t\tvar custom_field_types = [\n\t\t\t";
	foreach($ftypes as $ft)
	{
		$output .= "'" . $ft . "'";
		$output .= ", ";
	}
	$output = trim($output, "\n\r\t, ");
	echo $output;
	echo "\n\t\t\t];\n";
	
	$output = "";
	echo  "\t\t\tvar custom_field_lengths = [\n\t\t\t";
	foreach($flengths as $fl)
	{
		$output .= "'" . $fl . "'";
		$output .= ", ";
	}
	$output = trim($output, "\n\r\t, ");
	echo $output;
	echo "\n\t\t\t];\n";
	
	$output = "";
	echo  "\t\t\tvar domain_field_array = [\n\t\t\t";
	foreach($db_allowed_domain_columns as $field)
	{
		$output .= "'" . $field . "'";
		$output .= ", ";
	}
	$output = trim($output, "\n\r\t, ");
	echo $output;
	echo "\n\t\t\t];\n";
	
	echo "\t\t</script>\n";
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
		<title><?php echo $title; ?></title>
		<meta http-equiv="Content-Language" content="en">
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<link rel="shortcut icon" type="image/x-icon" href="lib/css/img/favicon.ico">
		
		<link type="text/css" href="lib/css/jqueryui/<?php echo $jqtheme; ?>/jquery-ui-1.8.7.custom.css" rel="stylesheet">
		<link type="text/css" href="lib/css/jqueryui/<?php echo $jqtheme; ?>/splitter.1.51.css" rel="stylesheet" media="screen">
		<link type="text/css" href="lib/css/jqueryui/splitter.1.51.css" rel="stylesheet" media="screen">
		<link type="text/css" href="lib/css/jqueryui/ui.jqgrid.css" rel="stylesheet" media="screen">

		<script type="text/javascript" src="lib/js/jquery/jquery-1.5.1.min.js"></script>
		<script type="text/javascript" src="lib/js/jquery/jquery.cookie.min.js"></script>
		<script type="text/javascript" src="lib/js/jquery/jquery-ui-1.8.7.noeffects.min.js"></script>
		<script type="text/javascript" src="lib/js/jquery/jquery.ui.touch-punch.min.js"></script>
		<script type="text/javascript" src="lib/js/jquery/splitter.1.51.min.js"></script>
		<script type="text/javascript" src="lib/js/jquery/i18n/grid.locale-en.js"></script>
		<script type="text/javascript" src="lib/js/jquery/jquery.jqGrid.3.8.2.min.js"></script>
		
		<link type="text/css" href="lib/css/default.css" rel="stylesheet" media="all">
		<link type="text/css" href="lib/css/<?php echo $jqtheme; ?>.css" rel="stylesheet" media="all">
		<script type="text/javascript" src="lib/js/buttons.js"></script>
		<link type="text/css" href="lib/css/appsetup.css" rel="stylesheet" media="screen">
		<script type="text/javascript" src="lib/js/utils.js"></script>
		<script type="text/javascript" src="lib/js/appsetup.js"></script>
<?php
		echoJSCustomFieldListArray();
		if(get_main_logo_image() != "")
			echo "\t\t<style> .mainlogo {background-image: url('" . get_main_logo_image() . "');}</style>\n";
?>
</head>
<body>
	<div id="header">
		<div class="mainlogo">&nbsp;</div>
		<div class="navbar">
				<button id="menu"></button>
				&nbsp;&nbsp;
				<button id="pfolio"></button>
				&nbsp;&nbsp;
		<?php
			if(is_admin_user())
			{
		?>
				<button id="subdomains"></button>
				<button id="report"></button>
				<button id="config"></button>
				<button id="admin"></button>
		<?php
			}
			show_link_buttons();
			if(is_user_auth_enabled())
			{
		?>
				&nbsp;&nbsp;
				<button id="logout"></button>
		<?php
			}
		?>
		</div>
		<div class="clear">&nbsp;</div>
	</div>
	
	<div id="SetupTabPane">
		<ul>
			<li><a href="#customfields">Custom Fields</a></li>
			<li><a href="#displaycolumns">Display Columns</a></li>
			<li><a href="#interface">Interface</a></li>
			<li><a href="#auth">Authentication</a></li>
			<li><a href="#lookupoptions">Lookup Options</a></li>
			<li><a href="#emailoptions">Email Options</a></li>
		</ul>
		<div id="emailoptions">
			<div class="toolcontainer">
				<div class="cfcontrolbox">
					<?php include('lib/php/appconfig/email.options.inc.php'); ?>
				</div>
				<div class="cfinfobox">
					<h4>Help</h4>
					<p>In most cases setting the <b>Send Method</b> to <b>Default</b>
					is sufficient.</p>
					
					<p>The &quot;To&quot; email address is specified in the individual report scripts.</p>
					
					<p>If you use GMail with SMTP and have enabled two-step authentication, 
					you should create an app specific password for use here. Please 
					<a href="https://support.google.com/mail/answer/1173270?hl=en" target="_blank">click here</a> for more details.</p>
					
					<p>The typical settings for GMail with SMTP are TLS, smtp.gmail.com and port 587.</p>
				</div>
				<div style="clear:both;"></div>
			</div>
		</div>
		<div id="lookupoptions">
			<div id="luoptfields">
				<?php include('lib/php/appconfig/lookup.options.inc.php'); ?>
			</div>
		</div>
		<div id="auth">
			<div id="luoptfields">
				<?php include('lib/php/appconfig/security.options.inc.php'); ?>
			</div>
		</div>
		<div id="interface">
			<div id="luoptfields">
				<?php include('lib/php/appconfig/interface.options.inc.php'); ?>
			</div>
		</div>
		<div id="customfields">
			<div class="toolcontainer">
				<div class="cfcontrolbox">
					<?php include('lib/php/appconfig/custom.fields.inc.php'); ?>
				</div>
				<div class="cfinfobox">
					<h4>Existing Fields</h4>
					<div id="allnames" class="currentfields">
						<?php echo $allcolumns; ?>
					</div>
				</div>
				<div style="clear:both;"></div>
			</div>
		</div>
		<div id="displaycolumns">
			<div id="displayfields">
				<div class="toolcontainer">
					<div class="dgselbox">
						<h3>Display Group</h3>
						
						<div class="dotline"></div>
						
						<p>Select the display group to modify.</p>
						
						<select id="display_group_name">
						  <option value="date_columns_array">Important Dates</option>
						  <option value="http_columns_array">Home Page Info</option>
						  <option value="registrar_columns_array">Registrar Info</option>
						  <option value="network_columns_array">Network Info</option>
						  <option value="sitepop_columns_array">Web Visibility Info</option>
						  <option value="notes_columns_array">Domain Notes</option>
						  <option value="ipdata_columns_array">IP Address Info</option>
						  <option value="custom_columns01_array">Custom Display 01</option>
						  <option value="custom_columns02_array">Custom Display 02</option>
						  <option value="report_columns_array">Report Display Columns</option>
						</select>
						
						<div class="dotline"></div>
						
						<p><button id="refresh_dg_domain_table" style="width:230px;">Refresh Domain Table</button></p>
					</div>
					
					<div class="dgcolumnsbox">
						<h3>Setup Domain Table Columns</h3>
						<div class="dotline"></div>
						<p style="padding-right:30px;">Check the fields you want to see as columns in the domain table. You can re-order the list by dragging 
						and dropping the columns at the grip icon (left side of each item).</p>
						<div id="displaylist">
							<ul id="tablecolumns">
								<?php echo getSelectableColumnsText("date_columns_array"); ?>
							</ul>
						</div>
					</div>
					
					<div class="dglabelbox">
						<h3>Settings</h3>
						<div class="dotline"></div>
						
						<p>Click on a column name at left to edit it's label and default column width.</p>
						
						<div class="dotline"></div>
						
						<h4 id="selectedcolumn">-</h4>
						<p><label for "column_label">Column Label</label>
						<input type="text" id="column_label" name="column_label" value="" style="width:180px;"></p>
						
						<p><label for "column_width">Column Width (Pixels)</label>
						<input type="text" id="column_width" name="column_width" value="" style="width:150px;"></p>
						
						<div class="dotline"></div>
						
						<br>
						
						<p>Click the 'Update Column List' to save your column selections.</p>
							
						<p><button id="ui_display_column_update" style="width:230px;">Update Column List</button></p>
						
					</div>

					<div style="clear:both;"></div>
				</div>
			</div>
		</div>
	</div>
</body>
</html>
<?php
?>
