<?php
///////////////////////////////////////////////////////////////////////////////
# Whois Script using GoDaddy API.
# Copyright (c) Softnik Technologies. All rights reserved.
#
# Use this for obtaining whois data for your own domains.
# Requires the API access and secret keys.
# This will fallback to regular port 43 whois for domains not in the profile.
///////////////////////////////////////////////////////////////////////////////

$gd_api_url_base   = 'https://api.godaddy.com/v1/domains/';
$gd_api_access_key = 'your_api_access_key';
$gd_api_secret_key = 'your_api_secret_key';

$do_whois_fallback = true;
$gd_whois_server   = "whois.godaddy.com";
$gd_whois_port     = 43;

$simplewhoispath   = "";

// Specify the URL of your normal php whois script above if you want to
// lookup non Godaddy registered domain names using the normal method.
// Eg.
// $simplewhoispath   = "http://local.example.com/whois/simplewhois.php?domain={D}";
// The {D} in the URL will be replaced with the actual domain name.

///////////////////////////////////////////////////////////////////////////////

function get_gdapi_domain_data($domain)
{
	global $gd_api_url_base, $gd_api_access_key, $gd_api_secret_key, $simplewhoispath;
	
	$gdurl = $gd_api_url_base . $domain;
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL,$gdurl);
	curl_setopt($ch, CURLOPT_TIMEOUT, 30); 
	curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array("Authorization: sso-key $gd_api_access_key:$gd_api_secret_key"));
	$result = curl_exec ($ch);
	$status_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	curl_close ($ch);
	if($result !== false)
	{
		$whoisok = true;
		$whois = json_decode($result, true);
		unset($whois['authCode']);
		if(isset($whois['code']))
		{
			if($whois['code'] == "NOT_FOUND")
				$whoisok = false;
		}
		if($whoisok)
		{
			$whois = setBooleanStatus($whois, array('holdRegistrar', 'privacy', 'expirationProtected', 'locked', 'renewAuto', 'renewable'));
			return $whois;
		}
		else
		{
			global $do_whois_fallback, $gd_whois_server, $gd_whois_port;
			if(!$do_whois_fallback)
				return array('Status' => 'Not Present in Domain List');
			else
			{
				if($simplewhoispath != "")
				{
					$url = str_replace("{D}", $domain, $simplewhoispath);
					
					$whois = file_get_contents($url);
					header("Content-Type: text/plain");
					echo $whois;
					
					// If file_get_contents is disabled/not working on your server,
					// Remove the comment on the line below and comment out the three lines above.
					
					//header('Location: '.$url);
					
					exit;
				}
				else
				{
					$whoisserver = $gd_whois_server;
					if(isset($_REQUEST['s']))
						$whoisserver = filter_var($_REQUEST['s'], FILTER_SANITIZE_STRING);
					if(($ns = fsockopen($whoisserver, $gd_whois_port)) == true)
					{
						$output = "";
						fputs($ns,"$domain\r\n");
						while(!feof($ns)) 
							$output .= fgets($ns,128); 
						fclose($ns);
						return $output;
					}
				}
			}
		}
	}
	else
		return false;
}

///////////////////////////////////////////////////////////////////////////////

function setBooleanStatus($whois, $keys)
{
	foreach($keys as $key)
	{
		if(isset($whois[$key]))
		{
			$v = $whois[$key];
			if($v == "" || $v == "0" || $v == 0)
				$v = "No";
			else if($v == "1" || $v == 1)
				$v = "Yes";
			$whois[$key] = $v;
		}
	}
	return $whois;
}

///////////////////////////////////////////////////////////////////////////////

$translate_array = array(

'domain' => 'Domain Name',
'domainId' => 'Registrar Domain ID',
'expires' => 'Registrar Registration Expiration Date',
'renewDeadline' => 'Renewal Deadline',
'createdAt' => 'Creation Date',
'nameServers' => 'Name Servers',
'contactRegistrant' => 'Registrant Contact',
'contactBilling' => 'Billing Contact',
'contactAdmin' => 'Admin Contact',
'contactTech' => 'Tech Contact',
'address1' => 'Street',
'address2' => 'Street',

);

///////////////////////////////////////////////////////////////////////////////

$domain = "";
if(isset($_REQUEST['d']))
	$domain = filter_var($_REQUEST['d'], FILTER_SANITIZE_STRING);

$rawdump = false;
if(isset($_REQUEST['raw']))
	$rawdump = true;

if($domain != "")
{
	$whois = get_gdapi_domain_data($domain);
	if($whois !== false)
	{
		if(is_array($whois))
		{
			if(!$rawdump)
			{
				header("Content-Type: text/plain");
				foreach($whois as $key=>$value)
				{
					printValue($key, $value);
				}
			}
			else
			{
				echo "<pre>";
				print_r($whois);
			}
		}
		else
		{
			header("Content-Type: text/plain");
			echo $whois;
		}
	}
}

///////////////////////////////////////////////////////////////////////////////

function getPrintKey($key)
{
	global $translate_array;
	
	if(isset($translate_array[$key]))
		return $translate_array[$key];
	else
		return ucfirst($key);
}

///////////////////////////////////////////////////////////////////////////////

$last_first_name = "";
$last_contact_type = "";

///////////////////////////////////////////////////////////////////////////////

function printValue($key, $value)
{
	global $last_first_name, $last_contact_type;
	if(is_array($value))
	{
		if(stripos($key, "contact") !== false)
		{
			$last_contact_type = str_ireplace("contact", "", $key) . " ";
		}
		if(stripos($key, "address") === false && $last_contact_type == "")
		{
			$key = getPrintKey($key);
			echo "$key:\n";
		}
		if(stripos($key, "name servers") === false)
		{
			foreach($value as $k=>$v)
				printValue($k, $v);
		}
		else
		{
			foreach($value as $k=>$v)
				echo "$v\n";
		}
			
		$last_contact_type = "";
	}
	else
	{	
		if(strtolower($key) == "expires" || strtolower($key) == "renewdeadline" || strtolower($key) == "createdat")
		{
			$fvalue = strtotime($value);
			$fvalue = date("d M Y", $fvalue);
			$value = $fvalue;
		}
		if(strtolower($key) == "domain")
			echo "Registrar: GoDaddy.com, LLC\n";
		if($key == 'nameFirst')
		{
			$last_first_name = $value;
			return;
		}
		else if($key == 'nameLast')
		{
			$value = $last_first_name . " " . $value;
			$key = "Name";
		}
		$key = getPrintKey($key);
		if(is_numeric($key))
			echo "$value\n";
		else
			echo "{$last_contact_type}{$key}: $value\n";
	}
}

///////////////////////////////////////////////////////////////////////////////
?>